<?php

namespace App\Client;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'password', 'api_token', 'pin_code', 'image', 'district_id', 'active');

    public function reviews()
    {
        return $this->hasMany('App\General\Review');
    }

    public function notifications()
    {
        return $this->morphMany('App\General\Notification', 'notificationable')is_read;
    }

    public function orders()
    {
        return $this->hasMany('App\General\Order');
    }

    public function token()
    {
        return $this->hasOne('App\General\Token');
    }

}